; (*| 21:08  6/01/1993 *)
TITLE	PIC
PAGE	60,78

LF	EQU 0AH
CR	EQU 0DH

MODE_LO_16	EQU 0EH		; Graphics 640 x 200, 16 colours
MODE_MED_16	EQU 10H		; Graphics 640 x 350, 16 colours
MODE_HI_16	EQU 12H		; Graphics 640 x 480, 16 colours
MODE_P_HI_16	EQU 5DH		; Graphics 1024 x 768, 16 colours
MODE_MED_256	EQU 13H		; Graphics 320 x 200, 256 colours
MODE_HI_256	EQU 5FH		; Graphics 640 x 480, 256 colours

DOSV_SETMODE	EQU 0
DOSV_SETCURS	EQU 2	
DOSV_RDCURS	EQU 3
DOSV_SETPAGE	EQU 5
DOSV_WRCHAR	EQU 0AH
DOSV_WRPIXEL	EQU 0CH
DOSV_RDPIXEL	EQU 0DH
DOSV_WRASTTY	EQU 0EH		; Write character as TTY
DOSV_GETVMODE	EQU 0FH		; Get Current Video Mode
DOSV_WRSTRING	EQU 13H

DOSK_GETKEY	EQU 0

DOSF_CONOUT	EQU  2		; Console output
DOSF_OUTSTR	EQU 09H		; Output string
DOSF_CREATEH	EQU 3CH
DOSF_OPENH	EQU 3DH
DOSF_CLOSEH	EQU 3EH
DOSF_READH	EQU 3FH
DOSF_WRITEH	EQU 40H
DOSF_MOVFPTR	EQU 42H
DOSF_TERMPROC	EQU 4CH

DOSI_VIDEO	EQU 10H		; Video interrupt
DOSI_KEYBOARD	EQU 16H		; Keyboard services
DOSI_TERM	EQU 20H		; Program terminate
DOSI_FUNC	EQU 21H		; Perform a function

; EGA Graphics Controller Registers

EGA_SEQ_WPM	EQU 2

EGA_GCR_DATA	EQU 0
EGA_GCR_ENABLE	EQU 1
EGA_GCR_RPS	EQU 4

CODE	SEGMENT
	ASSUME DS:CODE, CS:CODE ,ES:CODE
	ORG	0100H
START:
	JMP	SHORT BEGIN

COMMAND_OFFSET	DW	0080H
FCB1_EXT_OFFSET DW	0065H
COMMAND_LENGTH	DW	0
COMMAND_PTR	DW	16 DUP(0)	; 8 pairs, ptr+length
FILE_NAME_PTR	DW	?
FILE_NAME_LENGTH	DW	?
HANDLE_NUMBER	DW	?
FILE_LENGTH_LSW	DW	?
FILE_LENGTH_MSW	DW	?
FILE_PARAS	DW	?
FILE_BYTES	DW	?
EOF_POS		DW	?
VIDEO_SEGMENT	DW	0A000H
EGA_STATUS_0	DW	03C2H
EGA_SEQ_INDEX	DW	03C4H
EGA_GCR_INDEX	DW	03CEH
EGA_STATUS_1	DW	03DAH
SCREEN_WIDTH	DW	80
PCX_FLAG	DB	0
C256_FLAG	DB	0
P5D_FLAG	DB	0
PCX_PLANES	DB	?
PCX_VERSION     DB      ?
PALETTE_SIZE	DW	0
DATA_WIDTH	DW	?		; width in bytes
DATA_HEIGHT	DW	?		; height in lines
OLD_MODE	DB	?
OLD_PAGE	DB	?
COLOUR_DATA	DB	1111B		; whitei background
ENABLE_DATA	DB	1100B		; redi foreground
MASK_DATA	DB	1111B		; enabled write planes
TAIL_COUNT	DW	0
TAIL_DATA	DB	0
CMD_PAGE	DB	0
BAR_LINES	DB	0
BAR_LINES_QTY	DW	128
HI_256_FLAG	DB	0
DEST_HANDLE	DW	0
FREE_SEG	DW	?
RLE_CHAR	DB	?
RLE_COUNT	DW	0
MAX_FILE_SIZE	DW	0FF00H
MODE_TO_USE	DB	MODE_MED_16

BEGIN:
	CLD
	MOV	SP,OFFSET OUR_STACK
	MOV	DX,OFFSET TITMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	CALL	PROCESS_COMMAND_STRING
	MOV	SI,WORD PTR CS:COMMAND_PTR
	MOV	CX,WORD PTR CS:COMMAND_PTR+2	;length
	CMP	CX,0
	JZ	NO_COMMAND
	CMP	BYTE PTR [SI],'?'
	JNZ	NOT_HELP
NO_COMMAND:
	MOV	DX,OFFSET HLPMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	INT	DOSI_TERM

NOT_HELP:
	MOV	CX,1
	CALL	NOT_OPTION_COMMAND	;check number of / commands ??
	JB	NO_FILE		 ;skip if no plain command
	CALL	TEST_EXT
	CALL	OPEN_FILE
	MOV	CX, 2
	CALL	NOT_OPTION_COMMAND	;check number of / commands ??
	JB	NO_FILE_2	 	;skip if no pcx file command
	CALL	OPEN_DEST_FILE
NO_FILE_2:
	CALL	PROCESS_DATA
NO_FILE:
	INT	DOSI_TERM

TEST_EXT	PROC
	PUSH	SI
	PUSH	DI
	PUSH	CX
;	ADD	SI,CX
;	SUB	SI,3
	MOV	SI,WORD PTR FCB1_EXT_OFFSET
	MOV	CX,3
	MOV	DI,OFFSET PCX_MSG
	REP	CMPSB
	JNZ	NOT_PCX_EXT
	MOV	BYTE PTR PCX_FLAG,0FFH
NOT_PCX_EXT:
	POP	CX
	POP	DI
	POP	SI
	RET
TEST_EXT	ENDP

PROCESS_DATA	PROC
	MOV	AX,'f'
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_F_OPTION
	ADD	SI,2
	SUB	CX,2
	CALL	DEC_TO_BIN
	AND	AL,0FH
	MOV	BYTE PTR ENABLE_DATA,AL
NOT_F_OPTION:
	MOV	AX,'b'
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_B_OPTION
	ADD	SI,2
	SUB	CX,2
	CALL	DEC_TO_BIN
	AND	AL,0FH
	MOV	BYTE PTR COLOUR_DATA,AL
NOT_B_OPTION:
	MOV	AX,'m'
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_M_OPTION
	ADD	SI,2
	SUB	CX,2
	CALL	DEC_TO_BIN
	AND	AL,0FH
	MOV	BYTE PTR MASK_DATA,AL
NOT_M_OPTION:
	MOV	AX,'w'
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_W_OPTION
	ADD	SI,2
	SUB	CX,2
	CALL	DEC_TO_BIN
	MOV	BYTE PTR BAR_LINES,AL
NOT_W_OPTION:
	MOV	AX,'/1'
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_1_OPTION
	MOV	BYTE PTR CMD_PAGE,1
	MOV	WORD PTR VIDEO_SEGMENT,0B800H
NOT_1_OPTION:
	MOV	AX,'/2'
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_2_OPTION
	MOV	BYTE PTR CMD_PAGE,2
	MOV	WORD PTR EGA_STATUS_0,02C2H
	MOV	WORD PTR EGA_SEQ_INDEX,02C4H
	MOV	WORD PTR EGA_GCR_INDEX,02CEH
	MOV	WORD PTR EGA_STATUS_1,02DAH
NOT_2_OPTION:
	MOV	AX,'/5'
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_5_OPTION
	MOV	BYTE PTR P5D_FLAG,0FFH
	MOV	WORD PTR SCREEN_WIDTH,128
	MOV	BYTE PTR MODE_TO_USE,MODE_P_HI_16
NOT_5_OPTION:
	CMP	BYTE PTR PCX_FLAG,0FFH	; check if already set
	JE	DO_PCX_FILE
	MOV	AX,'/p'
	CALL	SEARCH_FOR_OPTIONS
;	JB	NOT_P_OPTION
	JNB	DO_PCX_FILE
	JMP	NOT_P_OPTION

DO_PCX_FILE:
	MOV	BYTE PTR PCX_FLAG,0FFH
	MOV	SI,OFFSET BUFFER
	MOV	AL,[SI+1]
	MOV	BYTE PTR PCX_VERSION,AL
	MOV	AL,[SI+3]
	CMP	AL,8
	JNE	NOT_256_COLOUR
	MOV	BYTE PTR C256_FLAG,0FFH
	MOV	WORD PTR PALETTE_SIZE,0100H
	MOV	WORD PTR SCREEN_WIDTH,320
	MOV	BYTE PTR MODE_TO_USE,MODE_MED_256
	CMP	BYTE PTR P5D_FLAG,0
	JE	SET_256
	MOV	WORD PTR SCREEN_WIDTH,640
	MOV	BYTE PTR MODE_TO_USE,MODE_HI_256
SET_256:
	PUSH	SI
	ADD	SI,WORD PTR FILE_LENGTH_LSW
	SUB	SI,300H
	MOV	CX,300H
	MOV	DI,OFFSET DAC_DATA
	REP	MOVSB
	POP	SI
	CALL	IS_VGA
	JE	NOT_256_COLOUR
	MOV	DX,OFFSET NO_VGA
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	RET				; abort if not VGA card

NOT_256_COLOUR:
	MOV	AX,[SI+10]
	SUB	AX,[SI+6]
	INC	AX
	MOV	WORD PTR DATA_HEIGHT,AX
	MOV	AL,[SI+65]
	MOV	BYTE PTR PCX_PLANES,AL
	CMP	AL,4
	JNE	NOT_FOUR_COLOUR
	MOV	BYTE PTR COLOUR_DATA,0
	MOV	BYTE PTR ENABLE_DATA,0
	MOV	WORD PTR BAR_LINES_QTY,32
	MOV	WORD PTR PALETTE_SIZE,0010H
	PUSH	SI
	ADD	SI,10H
	MOV	CX,30H
	MOV	DI,OFFSET DAC_DATA
	REP	MOVSB
	POP	SI
NOT_FOUR_COLOUR:
	MOV	AX,[SI+66]
	MOV	WORD PTR DATA_WIDTH,AX
	ADD	SI,128			; start of data
	JMP	SHORT DO_DATA

NOT_P_OPTION:
	MOV	SI,OFFSET BUFFER
	MOV	AX,[SI+4]
	MOV	CL,3
	SHR	AX,CL			; divide by 8
	MOV	WORD PTR DATA_WIDTH,AX
	MOV	AX,[SI+6]
	MOV	WORD PTR DATA_HEIGHT,AX
	ADD	SI,32			; start of data
DO_DATA:
	CMP	BYTE PTR CMD_PAGE,0
	JNE	NO_MODE_CHANGE
	CMP	BYTE PTR C256_FLAG,0
	JNE	NOT_VGA_HI		; mode already set to MED_256
	CMP	BYTE PTR P5D_FLAG,0
	JNE	NOT_VGA_HI		; mode already set to 5DH
	CALL	IS_VGA
	JNE	NOT_VGA_HI
	CMP	WORD PTR DATA_HEIGHT,350
	JBE	NOT_VGA_HI
	MOV	BYTE PTR MODE_TO_USE,MODE_HI_16
NOT_VGA_HI:
	MOV	AH,DOSV_GETVMODE
	INT	DOSI_VIDEO
	MOV	BYTE PTR OLD_MODE,AL
	MOV	BYTE PTR OLD_PAGE,BH	; save original settings
	CMP	AL,BYTE PTR MODE_TO_USE
	JE	NO_MODE_CHANGE
	MOV	AH,DOSV_SETMODE
	MOV	AL,BYTE PTR MODE_TO_USE
	INT	DOSI_VIDEO

	IFDEF	PAL_FILE

	CMP	BYTE PTR C256_FLAG,0
	JE	NO_MODE_CHANGE
	PUSH	SI
	CALL	GET_PALETTE
	POP	SI

	ELSE

	CMP	WORD PTR PALETTE_SIZE,0
	JE	NO_PALETTE_DATA
	CALL	SET_PALETTE
NO_PALETTE_DATA:

	ENDIF

NO_MODE_CHANGE:
	CALL	MOVE_DATA
	CALL	PROCESS_RLE
	MOV	AH,DOSK_GETKEY
	INT	DOSI_KEYBOARD
	CMP	BYTE PTR CMD_PAGE,0
	JNE	P_D_DONE
	MOV	AH,DOSV_SETMODE
	MOV	AL,BYTE PTR OLD_MODE
	CMP	AL,MODE_TO_USE
	JE	P_D_DONE
	INT	DOSI_VIDEO
P_D_DONE:
	RET
PROCESS_DATA	ENDP

MOVE_DATA	PROC
	SUB	DI,DI
	PUSH	DX
	PUSH	DS
	PUSH	ES
	MOV	AX,WORD PTR CS:VIDEO_SEGMENT
	MOV	ES,AX
	MOV	CX,WORD PTR CS:DATA_HEIGHT
NEXT_LINE:
	PUSH	CX
;	PUSH	SI
	PUSH	DI
	CMP	BYTE PTR CS:C256_FLAG,0
	JNE	SINGLE_PLANE
	CALL	DO_BARS
	MOV	DX,WORD PTR CS:EGA_GCR_INDEX
	MOV	AH,EGA_GCR_DATA
	MOV	AL,BYTE PTR CS:COLOUR_DATA ; Colour data
	CALL	OUT_PAIR
	MOV	AH,EGA_GCR_ENABLE
	MOV	AL,BYTE PTR CS:ENABLE_DATA ; Enable data
	CALL	OUT_PAIR		; CPU data selected where 0
	MOV	DX,WORD PTR CS:EGA_SEQ_INDEX
	MOV	AH,EGA_SEQ_WPM		; select Write Plane Mask
;	MOV	AL,01111B
;	MOV	AL,BYTE PTR CS:ENABLE_DATA
;	OR	AL,BYTE PTR CS:COLOUR_DATA ; enable requisite colour planes
	MOV	AL,BYTE PTR CS:MASK_DATA	; enable requisite colour planes
	CALL	OUT_PAIR
SINGLE_PLANE:
	MOV	CX,WORD PTR CS:DATA_WIDTH
	CMP	BYTE PTR CS:PCX_FLAG,0
	JZ	NOT_PCX_DATA
	CALL	PCX_LINE
	JMP	SHORT DONE_PCX_EXPAND
NOT_PCX_DATA:
	REP	MOVSB
DONE_PCX_EXPAND:
	POP	DI
;	POP	SI
	ADD	DI,WORD PTR CS:SCREEN_WIDTH
	CMP	BYTE PTR CS:P5D_FLAG,0
	JE	DI_OK
	CMP	DI,8000H
	JB	DI_OK
	SUB	DI,8000H
 	PUSH	DX
	MOV	DX, 3CEH		; gc_index
        MOV     AL, 9			; gc_pr_address_offset_a
        OUT     DX, AL
        INC     DX
        IN      AL, DX
        ADD     AL, 8			; select next bank
        OUT     DX, AL
	POP	DX
DI_OK:
;	ADD	SI,WORD PTR CS:DATA_WIDTH
	POP	CX
;	CMP	SI,WORD PTR CS:EOF_POS
;	JA	DONE_FILE
	CMP	SI,09000H
	JB	DSEG_OK
	SUB	SI,08000H
	MOV	AX,DS
	ADD	AX,00800H
	MOV	DS,AX
DSEG_OK:
	LOOP	NEXT_LINE
DONE_FILE:
	POP	ES
	POP	DS
	POP	DX
	RET
MOVE_DATA	ENDP

DO_BARS PROC
	PUSH	DI
	MOV	AL,BYTE PTR CS:BAR_LINES
	OR	AL,AL
	JZ	D_B_DONE
	PUSH	AX
	CALL	WAIT_ACTIVE_N
	MOV	DX,WORD PTR CS:EGA_SEQ_INDEX
	MOV	AH,EGA_SEQ_WPM		; select Write Plane Mask
	MOV	AL,01111B
	CALL	OUT_PAIR

	MOV	DX,WORD PTR CS:EGA_GCR_INDEX
	MOV	AH,EGA_GCR_DATA
	MOV	AL,01111B		; Colour data
	CALL	OUT_PAIR
;	MOV	AH,EGA_GCR_ENABLE
;	MOV	AL,01100b		; Enable data
;	CALL	OUT_PAIR		; CPU data selected where 0

	POP	AX
	MOV	CX,WORD PTR CS:SCREEN_WIDTH
	MUL	CL
	OR	DI,DI
	JNZ	NOT_FIRST_BAR
	ADD	CX,AX
	JMP	SHORT FIRST_BAR
NOT_FIRST_BAR:
	ADD	DI,AX
FIRST_BAR:
	MOV	AL,0FFH		 	; all background, whitei
	REP	STOSB
D_B_DONE:
	POP	DI
	RET
DO_BARS ENDP

WAIT_ACTIVE_N	PROC
	PUSH	CX
	MOV	CX,WORD PTR CS:BAR_LINES_QTY
W_A_N_LOOP:
	CALL	WAIT_ACTIVE
	LOOP	W_A_N_LOOP
	POP	CX
	RET
WAIT_ACTIVE_N	ENDP

WAIT_ACTIVE	PROC
	MOV	DX,WORD PTR CS:EGA_STATUS_1
W_A_LOOP_1:
	IN	AL,DX
	TEST	AL,01			; check for not in a retrace period
	JZ	W_A_LOOP_1
W_A_LOOP_2:
	IN	AL,DX
	TEST	AL,01			; check for in a retrace period
	JNZ	W_A_LOOP_2
	RET
WAIT_ACTIVE	ENDP

PCX_LINE	PROC
	CMP	BYTE PTR CS:PCX_PLANES,4
	JNE	PCX_MONO
	MOV	AL,1
	CALL	PCX_COLOUR_LINE
	MOV	AL,2
	CALL	PCX_COLOUR_LINE
	MOV	AL,4
	CALL	PCX_COLOUR_LINE
	MOV	AL,8
	CALL	PCX_COLOUR_LINE
	RET

PCX_MONO:
	CALL	PCX_EXPAND
	RET
PCX_LINE	ENDP

;AL=plane 

PCX_COLOUR_LINE PROC
	PUSH	AX
	PUSH	CX
	PUSH	DI
	MOV	DX,WORD PTR CS:EGA_SEQ_INDEX
	MOV	AH,EGA_SEQ_WPM		; select Write Plane Mask
	CALL	OUT_PAIR
	CALL	PCX_EXPAND
	POP	DI
	POP	CX
	POP	AX
	RET
PCX_COLOUR_LINE ENDP

PCX_EXPAND	PROC
	MOV	AX,WORD PTR CS:TAIL_COUNT
	OR	AX,AX
	JZ	PCX_NEW
	MOV	WORD PTR CS:TAIL_COUNT,0
	SUB	CX,AX
	PUSH	CX
	MOV	CX,AX
	MOV	AL,BYTE PTR CS:TAIL_DATA
	JMP	SHORT DO_MULTI

PCX_NEW:
	LODSB
	CMP	AL,0C0H
	JB	ONE_BYTE
	AND	AL,03FH
	CBW
	CMP	CX,AX
	JNB	NO_TAIL
	SUB	AX,CX
	MOV	WORD PTR CS:TAIL_COUNT,AX
	MOV	AX,CX
NO_TAIL:
	SUB	CX,AX
	PUSH	CX
	MOV	CX,AX
	LODSB
	MOV	BYTE PTR CS:TAIL_DATA,AL
DO_MULTI:
	REP	STOSB
	POP	CX
	OR	CX,CX
	JNZ	PCX_EXPAND
	RET

ONE_BYTE:
	STOSB
	LOOP	PCX_EXPAND
	RET
PCX_EXPAND	ENDP

; Count in CX, Source ptr in DS:SI

SET_PALETTE	PROC
	PUSH	SI
	PUSH	DI
	PUSH	BX
	PUSH	CX
	PUSH	DX

	MOV	SI,OFFSET DAC_DATA
	MOV	DX,SI
	MOV	DI,DX

	MOV	CX, WORD PTR PALETTE_SIZE
	MOV	AX,CX
	SHL	CX,1
	ADD	CX,AX		; cx := 3 * cx
SHIFT_PALETTE:
	LODSB
	SHR	AL,1
	SHR	AL,1
	STOSB
	LOOP	SHIFT_PALETTE
	MOV	CX, WORD PTR PALETTE_SIZE
	MOV	AX,1012H
	MOV	BX,0
	INT	DOSI_VIDEO
	CMP	BYTE PTR C256_FLAG,0
	JNE	SET_PAL_DONE
	MOV	AX,1002H
	MOV	DX,OFFSET DEFAULT_PAL
	INT	DOSI_VIDEO

SET_PAL_DONE:
	POP	DX
	POP	CX
	POP	BX
	POP	DI
	POP	SI
	RET
SET_PALETTE	ENDP

; Index in AH, Data in AL, Port in DX

OUT_PAIR	PROC
	XCHG	AL,AH
	CLI				; Disable
	CALL	OUTPUT			; Output index
	INC	DX
	XCHG	AL,AH
	CALL	OUTPUT			; Output data
	STI				; Re-enable
	DEC	DX
	RET
OUT_PAIR	ENDP

OUTPUT	PROC
	OUT	DX,AL
	RET
OUTPUT	ENDP

;process command string into individual commands or options

PROCESS_COMMAND_STRING	PROC
	MOV	SI,WORD PTR COMMAND_OFFSET	;080H, command string
	MOV	WORD PTR COMMAND_LENGTH,0
	MOV	CL,[SI]
	MOV	CH,0			; CX= length(command string)
	INC	SI
	MOV	DI,OFFSET COMMAND_PTR
	CMP	CX,0
	JZ	P_C_S_DONE		; ret if zero length
P_C_S_NEXT_CMD:
	MOV	AL,' '
	MOV	AH,'/'
P_C_S_SPACE_LOOP:
	CMP	[SI],AL
	JNZ	P_C_S_NOT_SPACE
	INC	SI
	LOOP	P_C_S_SPACE_LOOP
	JMP	SHORT P_C_S_DONE	; ret

P_C_S_NOT_SPACE:
	INC	WORD PTR COMMAND_LENGTH
	MOV	[DI],SI		 	; save ptr
P_C_S_N_S_LOOP:
	CMP	[SI],AL
	JZ	P_C_S_NEXT_SPACE
	INC	SI
	CMP	[SI],AH
	JZ	P_C_S_SLASH
	LOOP	P_C_S_N_S_LOOP
	JMP	SHORT P_C_S_NEXT_SPACE

P_C_S_SLASH:
	MOV	AX,SI
	DEC	SI
	INC	CX
	JMP	SHORT P_C_S_N_SLASH

P_C_S_NEXT_SPACE:
	MOV	BYTE PTR [SI],0	 ;mark end of string
	MOV	AX,SI
P_C_S_N_SLASH:
	SUB	AX,[DI]
	MOV	[DI+2],AX		;save length in next word
	ADD	DI,4			;next word pair
	INC	SI
	DEC	CX
	JLE	P_C_S_DONE
	CMP	WORD PTR COMMAND_LENGTH,8
	JL	P_C_S_NEXT_CMD
P_C_S_DONE:
	RET
PROCESS_COMMAND_STRING	ENDP

;search for options
;DX=option

SEARCH_FOR_OPTIONS	PROC
	MOV	DI,OFFSET COMMAND_PTR
	MOV	DX,AX
S_F_O_LOOP:
	CMP	BYTE PTR [DI+2],0	;command length
	JZ	S_F_O_NO_MORE
	MOV	SI,[DI]
	MOV	CX,[DI+2]
	MOV	AX,[SI]
	CMP	AL,'/'
	JNZ	S_F_O_NEXT_PAIR
	OR	AH,20H			;to lower
	CMP	AH,DL
	JZ	S_F_O_FOUND
S_F_O_NEXT_PAIR:
	ADD	DI,4			;next command pair
	JMP	SHORT	S_F_O_LOOP

S_F_O_FOUND:
	CLC
	RET

S_F_O_NO_MORE:
	STC
	RET
SEARCH_FOR_OPTIONS	ENDP

;get not option command n
;CL=command number

NOT_OPTION_COMMAND	PROC
	MOV	CH,CL
	MOV	CL,1
	MOV	DI,OFFSET COMMAND_PTR
N_O_C_LOOP:
	MOV	SI,[DI]
	OR	SI,SI
	JZ	N_O_C_NO_MORE
	CMP	BYTE PTR [SI],'/'
	JZ	N_O_C_NEXT_PAIR
	CMP	CH,CL
	JZ	N_O_C_OK
	INC	CL
N_O_C_NEXT_PAIR:
	ADD	DI,4
	JMP	SHORT	N_O_C_LOOP

N_O_C_NO_MORE:
	STC
	RET

N_O_C_OK:
	MOV	CX,[DI+2]		;CX=length
	CLC
	RET				;SI=command ptr
NOT_OPTION_COMMAND	ENDP

;write string at SI, nul terminated

WRITE_STRING_SI PROC
	MOV	AH,DOSF_CONOUT
W_S_SI_LOOP:
	MOV	DL,[SI]
	OR	DL,DL
	JZ	W_S_SI_DONE
	INT	DOSI_FUNC
	INC	SI
	JMP	SHORT	W_S_SI_LOOP

W_S_SI_DONE:
	RET
WRITE_STRING_SI ENDP

;source in [SI], count in CX, result in AL

DEC_TO_BIN	PROC
	SUB	BX,BX
D_T_B_LOOP:
	MOV	AL,BL
	MOV	BL,10
	MUL	BL
	MOV	BL,AL
	LODSB
	AND	AL,0FH
	ADD	BL,AL
	LOOP	D_T_B_LOOP
	MOV	AL,BL
	RET
DEC_TO_BIN	ENDP

GET_PALETTE	PROC
	MOV	DX, WORD PTR FILE_NAME_PTR
	MOV	DI,DX
	MOV	CX, WORD PTR FILE_NAME_LENGTH
	SUB	CX,3
	ADD	DI,CX
	MOV	CX,3
	MOV	SI, OFFSET PAL_MSG
	REP	MOVSB
	MOV	AX,DOSF_OPENH*256
	INT	DOSI_FUNC
	JB	G_P_DONE
	MOV	BX,AX			; handle
	MOV	CX,300H
	MOV	DX,OFFSET DAC_DATA
	MOV	AH,DOSF_READH		; read palette file
	INT	DOSI_FUNC
	JB	G_P_DONE
	MOV	AH,DOSF_CLOSEH
	INT	DOSI_FUNC
	MOV	AX,1012H
	SUB	BX,BX
	MOV	CX,100H
	MOV	DX,OFFSET DAC_DATA
	INT	DOSI_VIDEO
G_P_DONE:
	RET
GET_PALETTE	ENDP

;open font file

PARA_INC	EQU	0C00H

OPEN_FILE	PROC
	MOV	AX,OFFSET BUFFER
	SUB	WORD PTR MAX_FILE_SIZE,AX
	MOV	WORD PTR FILE_NAME_PTR,SI
	MOV	WORD PTR FILE_NAME_LENGTH,CX
	MOV	AX, CS
	MOV	WORD PTR FREE_SEG, AX
	MOV	DX,SI
	MOV	AX,DOSF_OPENH*256
	INT	DOSI_FUNC
	JNB	OPEN_OK
	MOV	DX,OFFSET L031B	 	; ' Cannot open input file: $'
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	SI,WORD PTR FILE_NAME_PTR
	CALL	WRITE_STRING_SI
	MOV	DX,OFFSET CRLFMSG	; CR,LF
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	AX,DOSF_TERMPROC*256 + 16
	INT	DOSI_FUNC

OPEN_OK:
	MOV	WORD PTR HANDLE_NUMBER,AX
	MOV	BX,AX
	MOV	AX,DOSF_MOVFPTR*256 + 2
	MOV	CX,0
	MOV	DX,0
	INT	DOSI_FUNC
	JNB	PTR_OK
PTR_DOS_ERROR:
	JMP	DOS_ERROR

PTR_OK:
	MOV	WORD PTR FILE_LENGTH_LSW,AX
	MOV	WORD PTR FILE_LENGTH_MSW,DX
	MOV	BX,AX
	AND	BX,000FH
	MOV	WORD PTR FILE_BYTES,BX
	MOV	BX,AX
	AND	BX,0FFF0H
	AND	DX,0000FH
	OR	BL,DL
	ROR	BX,1
	ROR	BX,1
	ROR	BX,1
	ROR	BX,1
	MOV	WORD PTR FILE_PARAS,BX
	MOV	BX, WORD PTR FILE_BYTES
	ADD	BX, OFFSET BUFFER
	ADD	BX, 0FH
	AND	BX, 0FFF0H
	ROR	BX, 1
	ROR	BX, 1
	ROR	BX, 1
	ROR	BX, 1
	ADD	BX, WORD PTR FILE_PARAS
	ADD	WORD PTR FREE_SEG, BX
	MOV	BX,WORD PTR MAX_FILE_SIZE
	OR	DX,DX
	JZ	SIZE_UNDER_64K
	MOV	AX,BX			; fudge AX to be quite big
SIZE_UNDER_64K:
	CMP	AX,BX
	JBE	SIZE_UNDER_63K
	MOV	AX,BX
SIZE_UNDER_63K:
	ADD	AX,OFFSET BUFFER
	MOV	WORD PTR EOF_POS,AX	; save end position
	MOV	BX,WORD PTR HANDLE_NUMBER
	MOV	AX,DOSF_MOVFPTR*256
	MOV	CX,0
	MOV	DX,0
	INT	DOSI_FUNC
	JB	PTR_DOS_ERROR
	MOV	BX,WORD PTR HANDLE_NUMBER
	MOV	CX,WORD PTR FILE_LENGTH_LSW
	MOV	DX,OFFSET BUFFER	; DS:DX => buffer
	MOV	AX,DS
	MOV	ES,AX			; ensure ES = DS
	PUSH	DS
	MOV	CX,WORD PTR ES:FILE_PARAS
READ_LOOP:
	CMP	CX,PARA_INC
	JB	DO_FILE_BYTES
	SUB	CX,PARA_INC
	MOV	WORD PTR ES:FILE_PARAS,CX
	MOV	CX,PARA_INC SHL 4
	JMP	SHORT DO_READ

DO_FILE_BYTES:
	ROL	CX,1
	ROL	CX,1
	ROL	CX,1
	ROL	CX,1
	OR	CX,WORD PTR ES:FILE_BYTES
	MOV	WORD PTR ES:FILE_PARAS,-1
DO_READ:
	OR	CX,CX
	JZ	READ_DONE
	MOV	AH,DOSF_READH		; read parameter file
	INT	DOSI_FUNC
	JNB	READ_OK
	POP	DS
	MOV	DX,OFFSET L0335	 ; ' Error reading parameter file: $'
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	SI,WORD PTR FILE_NAME_PTR
	CALL	WRITE_STRING_SI
	MOV	DX,OFFSET CRLFMSG	 ;CR,LF
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	AX,DOSF_TERMPROC*256 + 18
	INT	DOSI_FUNC

READ_OK:
	MOV	AX,DS
	ADD	AX,PARA_INC		; number of 16 byte paras
	MOV	DS,AX
	MOV	CX,WORD PTR ES:FILE_PARAS
	CMP	CX,-1
	JZ	READ_DONE
	JMP	READ_LOOP

READ_DONE:
	POP	DS
	MOV	AH, DOSF_CLOSEH
	INT	DOSI_FUNC
	MOV	SI,WORD PTR FILE_NAME_PTR
	MOV	CX,WORD PTR FILE_NAME_LENGTH
	MOV	AL,'\'
	ADD	SI,CX
STRIP_LOOP:
	CMP	AL,[SI-1]
	JZ	STRIP_DONE
	DEC	SI
	LOOP	STRIP_LOOP
STRIP_DONE:
	MOV	WORD PTR FILE_NAME_PTR,SI	;file name, less path
	RET
OPEN_FILE	ENDP

DOS_ERROR	PROC
	MOV	DX,OFFSET L036A	 ;' DOS Error $'
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	AX,DOSF_TERMPROC*256 + 7
	INT	DOSI_FUNC
DOS_ERROR	ENDP

;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
IS_VGA	PROC
	MOV	AX,1A00H
	INT	DOSI_VIDEO
	CMP	AL,1AH
	RET
IS_VGA	ENDP


;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
OPEN_DEST_FILE	PROC
	MOV	DX, SI
	MOV	AH, DOSF_CREATEH
	MOV	CX, 0
	INT	DOSI_FUNC
	JB	OPEN_DEST_RET
	MOV	WORD PTR DEST_HANDLE, AX
	MOV	BX, AX
	MOV	SI, OFFSET BUFFER
	MOV	AX,[SI+8]
	SUB	AX,[SI+4]
	INC	AX
	MOV	WORD PTR PCX_SCREEN_WIDTH,AX
;	MOV	WORD PTR PCX_LINE_WIDTH,AX
	DEC	AX
	MOV	WORD PTR PCX_IMAGE_WIDTH,AX
	MOV	AX,[SI+10]
	SUB	AX,[SI+6]
	INC	AX
	MOV	WORD PTR PCX_SCREEN_HEIGHT,AX
	DEC	AX
	MOV	WORD PTR PCX_IMAGE_HEIGHT,AX
	ADD	SI, 10H
	MOV	DI, OFFSET PCX_PAL
	MOV	CX, 16*3
	REP	MOVSB
	MOV	CX, PCX_HDR_SIZE
	MOV	DX, OFFSET PCX_HDR
	MOV	AH, DOSF_WRITEH
	INT	DOSI_FUNC
OPEN_DEST_RET:
	RET
OPEN_DEST_FILE	ENDP

PROCESS_RLE	PROC
	MOV	BX, WORD PTR DEST_HANDLE
	OR	BX, BX
	JZ	DONE_PROCESS_RLE
	MOV	DX, WORD PTR EGA_GCR_INDEX
	MOV	AL, 0
	CALL	PROCESS_PLANE
	MOV	AL, 1
	CALL	PROCESS_PLANE
	MOV	AL, 2
	CALL	PROCESS_PLANE
	MOV	AL, 3
	CALL	PROCESS_PLANE
	MOV	AL, 0
	MOV	AH, EGA_GCR_RPS
	CALL	OUT_PAIR
	MOV	AH, DOSF_CLOSEH
	INT	DOSI_FUNC
DONE_PROCESS_RLE:
	RET
PROCESS_RLE	ENDP

PROCESS_PLANE	PROC
	MOV	WORD PTR RLE_COUNT, 0
	MOV	AH, EGA_GCR_RPS
	CALL	OUT_PAIR
	PUSH	DS
	PUSH	ES
	MOV	CL, AL
	MOV	AH, 1
	ROL	AH ,CL
	MOV	AL, 0D3H		; write plane mask
	MOV	SI ,AX
	MOV	CX, 80 * 480
	MOV	AX, FREE_SEG
	MOV	ES, AX
	MOV	AX, VIDEO_SEGMENT
	MOV	DS, AX
	SUB	DI, DI
	MOV	AX, SI
	STOSW
	SUB	SI, SI

   IFDEF UNPACKED
	PUSH	CX
	REP	MOVSB
	POP	CX
   ELSE
   	MOV	AL, [SI]
   	MOV	BYTE PTR CS:RLE_CHAR, AL
PLANE_LOOP:
	LODSB
	CMP	AL, BYTE PTR CS:RLE_CHAR
	JNE	NEW_RUN
	INC	WORD PTR CS:RLE_COUNT
	LOOP	PLANE_LOOP
	CALL	DO_NEW_RUN
	JMP	PLANE_DONE

NEW_RUN:
	CALL	DO_NEW_RUN
	LOOP	PLANE_LOOP

PLANE_DONE:
	MOV	AL, 0D2H		; terminator
	STOSB
	MOV	CX, DI
   ENDIF

	PUSH	ES
	POP	DS
	PUSH	DX
	SUB	DX, DX
	MOV	AH, DOSF_WRITEH
	MOV	BX, WORD PTR CS:DEST_HANDLE
	INT	DOSI_FUNC
	POP	DX
	POP	ES
	POP	DS
	RET
PROCESS_PLANE	ENDP

    IFNDEF UNPACKED
DO_NEW_RUN	PROC
	XCHG	AL, BYTE PTR CS:RLE_CHAR
	MOV	BX, WORD PTR CS:RLE_COUNT
	MOV	WORD PTR CS:RLE_COUNT, 1
	OR	BX, BX
	JNZ	RUN_NON_ZERO
	RET

RUN_NON_ZERO:
	CMP	BX, 1
	JNE	RUN_NOT_ONE
	MOV	AH, AL
	AND	AH, 0F8H
	CMP	AH, 0D0H		; is D0-D7 ?
	JE	BAD_CHAR
	MOV	AH, AL
	AND	AH, 0E0H
	CMP	AH, 0A0H		; is A0-BF ?
	JNE	CHAR_OK
BAD_CHAR:
	NOP				; problem if here
	NOP
	MOV	AH, AL
	MOV	AL, 0A1H		; count of 1
	STOSB
	MOV	AL, AH
CHAR_OK:
	STOSB
	RET

RUN_NOT_ONE:
	MOV	AH, AL
	CMP	BX, 01FH
	JA	RUN_NOT_SMALL
	MOV	AL, BL
	OR	AL, 0A0H		; nibble count
	STOSB
	MOV	AL, AH
	STOSB
	RET

RUN_NOT_SMALL:
	CMP	BX, 0FFH
	JA	RUN_NOT_MEDIUM
	MOV	AL, 0D0H		; byte count
	STOSB
	MOV	AL, BL
	STOSB
	MOV	AL, AH
	STOSB
	RET

RUN_NOT_MEDIUM:
	MOV	AL, 0D1H		; word count
	STOSB
	MOV	AL, BL
	STOSB
	MOV	AL, BH
	STOSB
	MOV	AL, AH
	STOSB
	RET

DO_NEW_RUN	ENDP
    ENDIF

;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
TITMSG 	DB	'PIC Program by B Whitnall, V2.0',CR,LF,'$'
HLPMSG 	DB	'USAGE :	PIC file [dest_rle_file][/P][/1][/2]',CR,LF
       	DB	'  /P .PCX compressed file, else .MSP',CR,LF
       	DB	'  /Wn wipe bar of n lines',CR,LF
       	DB	'  /Fn foreground colour n',CR,LF
       	DB	'  /Bn background colour n',CR,LF
       	DB	'  /Mn mask n',CR,LF
       	DB	'  /1 output to first EGA card',CR,LF
       	DB	'  /2 output to second EGA card',CR,LF
	DB	'  /5 Paradise mode 5D, 1024x768 16 colours'
CRLFMSG	DB	CR,LF,'$'
L031B	DB	' Cannot open input file: $'
L0335	DB	' Error reading font file: $'
L0350	DB	' File size out of range: $'
L036A	DB	' DOS Error $'
NO_VGA	DB	' This file requires a VGA adaptor$'
PCX_MSG	DB	'PCX'
PAL_MSG	DB	'PAL'


PCX_HDR	DB	00AH,005H,001H,001H
	DW	0000H,0000H
PCX_IMAGE_WIDTH:
	DW	013FH
PCX_IMAGE_HEIGHT:
	DW	00C7H
PCX_SCREEN_WIDTH:
	DW	0140H
PCX_SCREEN_HEIGHT:
	DW	00C8H
PCX_PAL:
	DB	000H,000H,000H, 080H,000H,000H
	DB	000H,080H,000H, 080H,080H,000H
	DB	000H,000H,080H, 080H,000H,080H
	DB	000H,080H,080H, 080H,080H,080H
	DB	0C0H,0C0H,0C0H, 0FFH,000H,000H
	DB	000H,0FFH,000H, 0FFH,0FFH,000H
	DB	000H,000H,0FFH, 0FFH,000H,0FFH
	DB	000H,0FFH,0FFH, 0FFH,0FFH,0FFH

	DB	000H,004H
PCX_LINE_WIDTH:
	DW	050H

	DB	001H,000H,000H,000H
	DB	000H,000H,000H,000H,000H,000H,000H,000H
	DB	000H,000H,000H,000H,000H,000H,000H,000H
	DB	000H,000H,000H,000H,000H,000H,000H,000H
	DB	000H,000H,000H,000H,000H,000H,000H,000H
	DB	000H,000H,000H,000H,000H,000H,000H,000H
	DB	000H,000H,000H,000H,000H,000H,000H,000H
	DB	000H,000H,000H,000H,000H,000H,000H,000H

PCX_HDR_SIZE	EQU	$-PCX_HDR

DEFAULT_PAL:
	DB	0,1,2,3,4,5,6,7
	DB	8,9,10,11,12,13,14,15,0

	ALIGN	16			; site on segment boundary
	DB	128 DUP ('S')
OUR_STACK:
DAC_DATA:
	DB	300H DUP ('D')
BUFFER:

	CODE	ENDS
;
END	START

